<?php
/* --------------------------------------------------------------
 ConfigurationRepository.php 2020-02-18
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Repositories;

use Gambio\Core\Configuration\Models\Read;
use Gambio\Core\Configuration\Models\Write;

/**
 * Interface ConfigurationRepository
 * @package Gambio\Core\Configuration\Repositories
 */
interface ConfigurationRepository
{
    /**
     * Searches for a language specific configuration.
     *
     * @param string $key
     * @param string $languageCode
     *
     * @return Read\Interfaces\Configuration|null
     */
    public function findWithLanguageCode(string $key, string $languageCode): ?Read\Interfaces\Configuration;
    
    
    /**
     * Searches for a language specific configuration.
     *
     * @param string $key
     * @param int    $languageId
     *
     * @return Read\Interfaces\Configuration|null
     */
    public function findWithLanguageId(string $key, int $languageId): ?Read\Interfaces\Configuration;
    
    
    /**
     * Searches for a configuration.
     *
     * @param string $key
     *
     * @return Read\Interfaces\Configuration|null
     */
    public function find(string $key): ?Read\Interfaces\Configuration;
    
    
    /**
     * Checks if configuration value for given key is available.
     *
     * @param string $key
     *
     * @return bool
     */
    public function has(string $key): bool;
    
    
    /**
     * Updates the configuration.
     *
     * @param Write\Interfaces\Configuration $configuration
     */
    public function update(Write\Interfaces\Configuration $configuration): void;
    
    
    /**
     * Adds the configuration.
     *
     * @param Write\Interfaces\Configuration $configuration
     */
    public function add(Write\Interfaces\Configuration $configuration): void;
    
    
    /**
     * Deletes configurations by key name.
     *
     * @param string ...$keys
     */
    public function delete(string ...$keys): void;
}